/*:
 * @plugindesc Simple Centered Item Menu
 * @author Undermax Games | Maxii1996
 * @url https://undermax.itch.io/
 * @target MZ
 *
 * @help
 */

(function() {

    Scene_Item.prototype.createHelpWindow = function() {
        const rect = new Rectangle(0, 0, Graphics.width, 100);
        this._helpWindow = new Window_Help(rect);
        this._helpWindow.move(0, (Graphics.height - 520) / 2, Graphics.width - 8, 60);
        this.addWindow(this._helpWindow);
    };


Scene_Item.prototype.createCategoryWindow = function() {
    const categoryRect = new Rectangle(0, 0, Graphics.width, 100);
    this._categoryWindow = new Window_ItemCategory(categoryRect);
    this._categoryWindow.setHandler('ok',     this.onCategoryOk.bind(this));
    this._categoryWindow.setHandler('cancel', this.popScene.bind(this));
    this._categoryWindow.hide();
    this._categoryWindow.deactivate();
    this._categoryWindow.selectSymbol('item');
};


Scene_Item.prototype.createItemWindow = function() {

    const windowWidth = Graphics.width - 8; 
    const windowHeight = 504;

    const wx = 0;
    const wy = 112;

    const itemListRect = new Rectangle(wx, wy, windowWidth, windowHeight);
    this._itemWindow = new Window_ItemList(itemListRect);
    this._itemWindow.setHelpWindow(this._helpWindow);
    this._itemWindow.setHandler('ok', this.onItemOk.bind(this));
    this._itemWindow.setHandler('cancel', this.popScene.bind(this));
    this.addWindow(this._itemWindow);
    this._itemWindow.selectLast();
    this._itemWindow.activate();
    this._categoryWindow.selectSymbol('item');
    this._itemWindow.setCategory('item');
    this._itemWindow.refresh();
    this._categoryWindow.deactivate();
    this._categoryWindow.hide();
    this._itemWindow.select(0);
    this._itemWindow.ensureCursorVisible();
    this._itemWindow.updateHelp();
};
    
    Window_ItemList.prototype.maxCols = function() {
        return 2;
    };

    Window_ItemCategory.prototype.makeCommandList = function() {
        this.addCommand(TextManager.item, 'item');
        this.addCommand(TextManager.weapon, 'weapon');
        this.addCommand(TextManager.armor, 'armor');
        this.addCommand(TextManager.keyItem, 'keyItem');
    };

})();